-- ============================================================================
-- === CustomFruitTypes.Lua
-- === MOD my [LSMT] Modding Team
-- === LS25 / FS25
-- === Script by [LSMT] Modding Team @ 2025
-- === Ver 0.0.0.3 (MP-fähig)
-- ============================================================================

local modDirectory = g_currentModDirectory

local function overwrittenLoadDefaultTypes(self, originalFunction)
    if g_currentMission and g_currentMission.getIsServer and g_currentMission:getIsServer() then
        local xmlFile = loadXMLFile("fruitTypes", modDirectory .. "xml/maps_fruitTypes.xml")
        if xmlFile ~= 0 then
            self:loadFruitTypes(xmlFile, nil, modDirectory, true)
            delete(xmlFile)
        else
            originalFunction(self)
        end
    else
        originalFunction(self)
    end
end

FruitTypeManager.loadDefaultTypes = Utils.overwrittenFunction(
    FruitTypeManager.loadDefaultTypes,
    overwrittenLoadDefaultTypes
)